<?php
include "config.php";
if (!isset($_SESSION["admin"])) {
    header("Location: login");
    exit;
}

// --- Load data ---
$articleFile = __DIR__ . "/article.json";
$articles = file_exists($articleFile) ? json_decode(file_get_contents($articleFile), true) : [];

$appearanceFile = __DIR__ . "/appearance.json";
$appearance = file_exists($appearanceFile) ? json_decode(file_get_contents($appearanceFile), true) : ["banners" => []];

$linksFile = __DIR__ . "/links.json";
$links = file_exists($linksFile) ? json_decode(file_get_contents($linksFile), true) : [];

// --- Cek halaman aktif ---
$currentPage = basename($_SERVER['PHP_SELF']);
$currentProvider = $_GET['provider'] ?? '';
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin</title>
    <meta name="google" content="notranslate">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        #sidebar::-webkit-scrollbar {
            width: 6px;
        }

        #sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        #sidebar::-webkit-scrollbar-thumb {
            background: #9ca3af;
            border-radius: 4px;
        }

        #sidebar::-webkit-scrollbar-thumb:hover {
            background: #6b7280;
        }

        #sidebar {
            scrollbar-width: thin;
            scrollbar-color: #9ca3af transparent;
        }

        #sidebar::-webkit-scrollbar {
            display: none;
        }

        #sidebar:hover::-webkit-scrollbar {
            display: block;
        }

        .collapsed {
            width: 4rem !important;
        }

        .collapsed .menu-text {
            display: none;
        }

        .tooltip {
            position: relative;
        }

        .tooltip .tooltip-text {
            visibility: hidden;
            opacity: 0;
            position: absolute;
            left: 3.5rem;
            top: 50%;
            transform: translateY(-50%);
            background: #111827;
            color: white;
            padding: 4px 8px;
            border-radius: 4px;
            white-space: nowrap;
            transition: opacity 0.2s;
            z-index: 100;
            font-size: 0.875rem;
        }

        .tooltip:hover .tooltip-text {
            visibility: visible;
            opacity: 1;
        }
    </style>
</head>

<body class="bg-gray-100 min-h-screen flex flex-col">

    <!-- Header -->
    <header class="bg-gray-800 text-white p-4 flex justify-between items-center">
        <h1 class="text-lg font-semibold">Selamat datang, <?php echo $_SESSION["admin"]; ?></h1>
        <div class="flex gap-2">
            <button id="collapseToggle" class="hidden md:block px-3 py-2 border border-gray-500 rounded">⏪</button>
            <button id="menuToggle" class="md:hidden px-3 py-2 border border-gray-500 rounded">☰</button>
        </div>
    </header>

    <div class="flex flex-1">
        <!-- Sidebar -->
        <nav id="sidebar" class="bg-gray-200 w-64 p-4 space-y-3 fixed md:static inset-y-0 left-0 transform -translate-x-full md:translate-x-0 transition-all duration-200 ease-in-out z-50 h-screen overflow-y-auto">

            <!-- Menu Utama -->
            <a href="seo_edit" class="tooltip flex items-center gap-3 h-12 px-4 rounded text-white <?php echo $currentPage == 'seo_edit.php' ? 'bg-gray-800' : 'bg-gray-600 hover:bg-gray-500'; ?>">
                📈 <span class="menu-text whitespace-nowrap overflow-hidden text-ellipsis">Kelola SEO</span>
                <span class="tooltip-text">Kelola SEO</span>
            </a>
            <a href="article_list" class="tooltip flex items-center gap-3 h-12 px-4 rounded text-white <?php echo $currentPage == 'article_list.php' ? 'bg-gray-800' : 'bg-gray-600 hover:bg-gray-500'; ?>">
                📄 <span class="menu-text whitespace-nowrap overflow-hidden text-ellipsis">Kelola Artikel</span>
                <span class="tooltip-text">Kelola Artikel</span>
            </a>
            <a href="appearance_edit" class="tooltip flex items-center gap-3 h-12 px-4 rounded text-white <?php echo $currentPage == 'appearance_edit.php' ? 'bg-gray-800' : 'bg-gray-600 hover:bg-gray-500'; ?>">
                🎨 <span class="menu-text whitespace-nowrap overflow-hidden text-ellipsis">Kelola Tampilan</span>
                <span class="tooltip-text">Kelola Tampilan</span>
            </a>
            <a href="links_edit" class="tooltip flex items-center gap-3 h-12 px-4 rounded text-white <?php echo $currentPage == 'links_edit.php' ? 'bg-gray-800' : 'bg-gray-600 hover:bg-gray-500'; ?>">
                🔗 <span class="menu-text whitespace-nowrap overflow-hidden text-ellipsis">Kelola Link Alternatif</span>
                <span class="tooltip-text">Kelola Link Alternatif</span>
            </a>
            <a href="info_edit" class="tooltip flex items-center gap-3 h-12 px-4 rounded text-white <?php echo $currentPage == 'info_edit.php' ? 'bg-gray-800' : 'bg-gray-600 hover:bg-gray-500'; ?>">
                📑 <span class="menu-text whitespace-nowrap overflow-hidden text-ellipsis">Kelola Info Tabel Slot</span>
                <span class="tooltip-text">Kelola Info Tabel Slot</span>
            </a>
            <a href="provider_edit" class="tooltip flex items-center gap-3 h-12 px-4 rounded text-white <?php echo $currentPage == 'provider_edit.php' ? 'bg-gray-800' : 'bg-gray-600 hover:bg-gray-500'; ?>">
                🏢 <span class="menu-text whitespace-nowrap overflow-hidden text-ellipsis">Kelola Provider</span>
                <span class="tooltip-text">Kelola Provider</span>
            </a>
            <a href="import_games" class="tooltip flex items-center gap-3 h-12 px-4 rounded text-white bg-gray-600 hover:bg-gray-500">
                <span class="w-6 h-6 flex items-center justify-center">⬇️</span>
                <span class="menu-text whitespace-nowrap overflow-hidden text-ellipsis">Import Game</span>
                <span class="tooltip-text">Import Game dari Website</span>
            </a>

            <!-- Dropdown Kelola Game -->
            <div class="space-y-2">
                <button id="toggleGames"
                    class="flex items-center justify-between w-full h-12 px-4 rounded text-white 
        <?php echo $currentPage == 'games_edit.php' ? 'bg-gray-800' : 'bg-gray-600 hover:bg-gray-500'; ?>">
                    <div class="flex items-center gap-3">
                        🎮 <span class="menu-text whitespace-nowrap overflow-hidden text-ellipsis">Kelola Game</span>
                    </div>
                    <span id="arrowGames" class="transition-transform">▼</span>
                </button>

                <!-- Tambahkan transition max-height -->
                <div id="gamesMenu" class="pl-4 space-y-2 max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                    <?php
                    $games = [
                        "pragmatic"   => ["name" => "Pragmatic",   "icon" => "https://files.sitestatic.net/images/ppslot.gif?v=1.0"],
                        "pgsoft"      => ["name" => "PG Soft",     "icon" => "https://files.sitestatic.net/images/pgsoft.gif?v=0.2"],
                        "habanero"    => ["name" => "Habanero",    "icon" => "https://files.sitestatic.net/assets/imgs/game_logos/100x70/hb_slot.png?v=0.2"],
                        "CQ9"         => ["name" => "CQ9",         "icon" => "https://files.sitestatic.net/assets/imgs/game_logos/100x70/cq9_slot.png?v=0.2"],
                        "spadegaming" => ["name" => "SpadeGaming", "icon" => "https://files.sitestatic.net/assets/imgs/game_logos/100x70/sg_slot.png?v=0.2"],
                        "joker"       => ["name" => "Joker",       "icon" => "https://files.sitestatic.net/assets/imgs/game_logos/100x70/jk_slot.png?v=0.2"],
                        "playtech"    => ["name" => "Playtech",    "icon" => "https://files.sitestatic.net/assets/imgs/game_logos/100x70/pt_slot.png?v=0.2"],
                        "microgaming" => ["name" => "Microgaming", "icon" => "https://files.sitestatic.net/assets/imgs/game_logos/100x70/mg_slot.png?v=0.2"],
                        "netent"      => ["name" => "Netent",      "icon" => "https://files.sitestatic.net/assets/imgs/game_logos/100x70/redtiger_net_slot.png?v=0.2"],
                        "yggdrasil"   => ["name" => "YGGDrasil",   "icon" => "https://files.sitestatic.net/assets/imgs/game_logos/100x70/yggslot.png?v=0.2"],
                        "redtiger"    => ["name" => "Redtiger",    "icon" => "https://files.sitestatic.net/assets/imgs/game_logos/100x70/redtiger_slot.png?v=0.2"],
                        "nolimitcity" => ["name" => "Nolimitcity", "icon" => "https://files.sitestatic.net/assets/imgs/game_logos/100x70/nolimitcity_slot.png?v=0.2"]
                    ];
                    foreach ($games as $key => $game): ?>
                        <a href="games_edit?provider=<?php echo $key; ?>"
                            class="flex items-center gap-3 h-12 px-4 rounded text-white 
                <?php echo ($currentPage == 'games_edit.php' && $currentProvider == $key)
                            ? 'bg-gray-800' : 'bg-gray-500 hover:bg-gray-400'; ?>">
                            <span class="w-6 h-6 flex items-center justify-center">
                                <img src="<?php echo $game['icon']; ?>" alt="<?php echo $game['name']; ?> Icon" class="w-6 h-6 object-contain">
                            </span>
                            <span class="menu-text whitespace-nowrap overflow-hidden text-ellipsis"><?php echo $game['name']; ?></span>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>


            <!-- Logout -->
            <a href="logout" class="tooltip flex items-center gap-3 h-12 px-4 rounded text-white <?php echo $currentPage == 'logout.php' ? 'bg-red-800' : 'bg-red-600 hover:bg-red-500'; ?>">
                🚪 <span class="menu-text whitespace-nowrap overflow-hidden text-ellipsis">Logout</span>
                <span class="tooltip-text">Logout</span>
            </a>
        </nav>

        <!-- Overlay -->
        <div id="overlay" class="fixed inset-0 bg-black bg-opacity-50 hidden md:hidden"></div>

        <!-- Content -->
        <main class="flex-1 md:ml-64 p-6 transition-all duration-200 ease-in-out" id="mainContent">
            <h2 class="text-2xl font-bold mb-6">Dashboard Admin</h2>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                <div class="bg-white rounded-xl shadow p-5 text-center">
                    <h3 class="text-lg font-semibold text-gray-600">Artikel</h3>
                    <p class="text-3xl font-bold text-blue-600"><?php echo count($articles); ?></p>
                </div>
                <div class="bg-white rounded-xl shadow p-5 text-center">
                    <h3 class="text-lg font-semibold text-gray-600">Banner</h3>
                    <p class="text-3xl font-bold text-green-600"><?php echo count($appearance["banners"]); ?></p>
                </div>
                <div class="bg-white rounded-xl shadow p-5 text-center">
                    <h3 class="text-lg font-semibold text-gray-600">Link Alternatif</h3>
                    <p class="text-3xl font-bold text-purple-600"><?php echo count($links); ?></p>
                </div>
            </div>

            <p class="text-black-700">Silakan pilih menu untuk mulai mengelola.</p>
        </main>
    </div>

    <script>
        const sidebar = document.getElementById("sidebar");
        const overlay = document.getElementById("overlay");
        const menuToggle = document.getElementById("menuToggle");
        const collapseToggle = document.getElementById("collapseToggle");
        const mainContent = document.getElementById("mainContent");

        // Sidebar mobile
        menuToggle.addEventListener("click", () => {
            sidebar.classList.toggle("-translate-x-full");
            overlay.classList.toggle("hidden");
        });
        overlay.addEventListener("click", () => {
            sidebar.classList.add("-translate-x-full");
            overlay.classList.add("hidden");
        });

        // Collapse sidebar
        collapseToggle.addEventListener("click", () => {
            sidebar.classList.toggle("collapsed");
            mainContent.classList.toggle("md:ml-16");
            mainContent.classList.toggle("md:ml-64");
            collapseToggle.textContent = sidebar.classList.contains("collapsed") ? "⏩" : "⏪";
        });

        // Dropdown Kelola Game dengan animasi
        const toggleGames = document.getElementById("toggleGames");
        const gamesMenu = document.getElementById("gamesMenu");
        const arrowGames = document.getElementById("arrowGames");

        toggleGames.addEventListener("click", () => {
            if (gamesMenu.classList.contains("max-h-0")) {
                gamesMenu.classList.remove("max-h-0");
                gamesMenu.classList.add("max-h-[1000px]"); // cukup besar supaya muat semua
                arrowGames.classList.add("rotate-180");
            } else {
                gamesMenu.classList.remove("max-h-[1000px]");
                gamesMenu.classList.add("max-h-0");
                arrowGames.classList.remove("rotate-180");
            }
        });
    </script>
</body>

</html>