<?php
include "config.php";
if (!isset($_SESSION["admin"])) {
    header("Location: login");
    exit;
}

$file = __DIR__ . "/article.json";
if (!file_exists($file)) {
    file_put_contents($file, json_encode([], JSON_PRETTY_PRINT));
}
$data = json_decode(file_get_contents($file), true);

// hapus artikel
if (isset($_GET["delete"])) {
    $slug = $_GET["delete"];
    if (isset($data[$slug])) {
        unset($data[$slug]);
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }
    header("Location: article_list?msg=" . urlencode("Artikel '$slug' berhasil dihapus!"));
    exit;
}

// pesan notifikasi
$msg = $_GET["msg"] ?? "";

// pencarian & filter
$search = $_GET["search"] ?? "";
$filterDate = $_GET["date"] ?? "";

$filtered = [];
foreach ($data as $slug => $article) {
    $match = true;

    // filter judul/slug
    if ($search !== "") {
        $match = (stripos($article["title"] ?? "", $search) !== false) 
              || (stripos($slug, $search) !== false);
    }

    // filter tanggal
    if ($match && $filterDate !== "") {
        $match = strpos($article["created_at"] ?? "", $filterDate) === 0;
    }

    if ($match) {
        $filtered[$slug] = $article;
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Artikel</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="/admin/confirm-delete.js"></script>
</head>
<body class="bg-gray-100 p-4 md:p-8">

    <h2 class="text-2xl font-bold mb-4">📑 Daftar Artikel</h2>

    <?php if ($msg): ?>
        <script>
            document.addEventListener("DOMContentLoaded", function () {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'success',
                    title: <?php echo json_encode($msg); ?>,
                    showConfirmButton: false,
                    timer: 2500,
                    timerProgressBar: true
                });
            });
        </script>
    <?php endif; ?>

    <div class="mb-4 flex flex-col md:flex-row md:items-center md:justify-between gap-3">
        <a href="article_add" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-500 w-full md:w-auto text-center">➕ Tambah Artikel</a>

        <form method="get" class="flex flex-col sm:flex-row gap-2 w-full md:w-auto">
            <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" placeholder="Cari judul atau slug..."
                class="flex-1 p-2 border rounded">
            <input type="date" name="date" value="<?php echo htmlspecialchars($filterDate); ?>"
                class="p-2 border rounded">
            <button type="submit" class="px-4 py-2 bg-gray-700 text-white rounded hover:bg-gray-600">🔍 Cari</button>
            <?php if ($search !== "" || $filterDate !== ""): ?>
                <a href="article_list" class="px-4 py-2 bg-red-500 text-white rounded hover:bg-red-600 text-center">❌ Reset</a>
            <?php endif; ?>
        </form>
    </div>

    <div class="bg-white rounded shadow overflow-x-auto">
        <table class="min-w-full text-sm">
            <thead class="bg-gray-200 text-gray-700">
                <tr>
                    <th class="px-3 py-2 border">Judul</th>
                    <th class="px-3 py-2 border">Slug</th>
                    <th class="px-3 py-2 border">Gambar</th>
                    <th class="px-3 py-2 border">Tanggal</th>
                    <th class="px-3 py-2 border">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($filtered)): ?>
                    <?php foreach ($filtered as $slug => $article): ?>
                        <tr class="odd:bg-white even:bg-gray-50">
                            <td class="px-3 py-2 border"><?php echo htmlspecialchars($article["title"] ?? ""); ?></td>
                            <td class="px-3 py-2 border"><?php echo htmlspecialchars($slug); ?></td>
                            <td class="px-3 py-2 border">
                                <?php if (!empty($article["image"])): ?>
                                    <img src="<?php echo htmlspecialchars($article["image"]); ?>" alt="thumb" class="w-20 rounded">
                                <?php else: ?>
                                    <span class="text-gray-400 italic">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-3 py-2 border"><?php echo htmlspecialchars($article["created_at"] ?? ""); ?></td>
                            <td class="px-3 py-2 border text-center space-x-2">
                                <a href="article_add?edit=<?php echo urlencode($slug); ?>" class="text-blue-600 hover:underline">✏️ Edit</a>
                                <a href="?delete=<?php echo urlencode($slug); ?>" class="btn-delete bg-red-600 text-white px-2 py-1 rounded"
                                   data-url="?delete=<?php echo urlencode($slug); ?>">🗑 Hapus</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="px-3 py-4 text-center text-gray-500">Tidak ada artikel ditemukan.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-6">
        <a href="dashboard" class="text-blue-600 hover:underline">⬅ Kembali ke Dashboard</a>
    </div>

</body>
</html>
